*** This file contains the primary analysis of the Eurobarometer data

*** Table 4: Macro
use "Processed files/eurobarometer_macro", clear
set more off

* Panels
reg sat_hat lgdp_q, cluster(cty)
xi: reg sat_hat lgdp_q i.cty, cluster(cty)
xi: reg sat_hat lgdp_q i.cty i.date, cluster(cty)

reg hap_hat lgdp_q, cluster(cty)
xi: reg hap_hat lgdp_q i.cty, cluster(cty)
xi: reg hap_hat lgdp_q i.cty i.date, cluster(cty)

* First differences: Five-year panel
use "Processed files/eurobarometer_macro", clear
gen yr5=int((year-1973)/5)*5
collapse (mean) sat_hat gdp_q [aw=nsat], by(yr5 cty)
gen lgdp=ln(gdp)
egen ctyid=group(cty)
tsset ctyid yr5, delta(5)
reg d.sat_hat d.lgdp
use "Processed files/eurobarometer_macro", clear
gen yr5=int((year-1973)/5)*5
collapse (mean) hap_hat gdp_q [aw=nhap], by(yr5 cty)
gen lgdp=ln(gdp)
egen ctyid=group(cty)
tsset ctyid yr5, delta(5)
reg d.hap_hat d.lgdp

* First differences: Decadal panel
use "Processed files/eurobarometer_macro", clear
gen decade=int((year-1970)/10)*10
collapse (mean) sat_hat gdp_q [aw=nsat], by(decade cty)
gen lgdp=ln(gdp)
egen ctyid=group(cty)
tsset ctyid decade, delta(10)
reg d.sat_hat d.lgdp
use "Processed files/eurobarometer_macro", clear
gen decade=int((year-1970)/10)*10
collapse (mean) hap_hat gdp_q [aw=nhap], by(decade cty)
gen lgdp=ln(gdp)
egen ctyid=group(cty)
tsset ctyid decade, delta(10)
reg d.hap_hat d.lgdp

*** Table 4: Micro
use "Processed files/eurobarometer_micro", clear
oprobit sat lgdp_q [pw=wt], cluster(cty)
xi: oprobit sat lgdp_q i.cty [pw=wt], cluster(cty)
xi: oprobit sat lgdp_q i.cty i.date [pw=wt], cluster(cty)

oprobit hap lgdp_q [pw=wt], cluster(cty)
xi: oprobit hap lgdp_q i.cty [pw=wt], cluster(cty)
xi: oprobit hap lgdp_q i.cty i.date [pw=wt], cluster(cty)


* Figure 16
use "Processed files/eurobarometer_macro", clear
gen sat_dev=.
levelsof cty, local(ctys)
foreach c of local ctys {
	summ sat_hat if cty=="`c'"
	replace sat_dev=sat_hat-r(mean) if cty=="`c'"
}

* 9-panel graph
gen easterlin=.
for X in any DNK NLD BEL IRL GBR FRG GRC FRA ITA: replace easterlin=1 if cty=="X"
gen str12 country=""
for X in any DNK NLD BEL IRL GBR FRG GRC FRA ITA \ Y in any Denmark Netherlands Belgium Ireland "United Kingdom" "West Germany" Greece France Italy: replace country="Y" if cty=="X"
tab country

preserve
gen sat_dev_fit=.
keep if easterlin==1
egen d=rank(date), by(cty)
tsset ctyid d
levelsof cty, local(countries)
foreach c of local countries {
	newey sat_dev lgdp_q if cty=="`c'", lag(1)
	predict h
	replace sat_dev_fit=h if cty=="`c'"
	global a=string(_b[_cons],"%3.2f")
	global b=string(_b[lgdp_q],"%3.2f")
	global se=string(_se[lgdp_q],"%3.2f")
	correl sat_dev lgdp_q if cty=="`c'"
	global rho=string(r(rho),"%3.2f")
	levelsof country if cty=="`c'", local(cty_name)
	local nox=""
	if "`c'"=="BEL" | "`c'"=="DNK" | "`c'"=="GRC" | "`c'"=="FRA" | "`c'"=="IRL" | "`c'"=="ITA" {
		local nox="nolabel"
	}
	local noy=""
	if "`c'"=="DNK" | "`c'"=="GRC" | "`c'"=="IRL" | "`c'"=="ITA" | "`c'"=="GBR" | "`c'"=="FRG" {
		local noy="nolabel"
	}
	
	
	#delimit ;
	twoway
		(scatter sat_dev gdp_q if year>1989, msymbol(circle_hollow) mcolor(navy))
		(scatter sat_dev gdp_q if year<=1989, msymbol(circle) mcolor(navy))
		(line sat_dev_fit gdp_q, sort lpattern(dash) lwidth(medthick) lcolor(black))
		if cty=="`c'"
	,
		subtitle(`cty_name', ring(0))
		xtitle("")
		xscale(log)
		ylabel(-.5(.25).5, `noy' angle(horizontal) format(%4.2f))
		xlabel(8000 "8" 16000 "16" 32000 "32", `nox')
		note("y = $a + $b * log(GDP) [se=$se]" "Correlation = $rho", ring(0) pos(5) size(small))
		legend(off)
		xsize(10) ysize(7.5)
		name(sat_`c', replace)
	;
	#delimit cr
	drop h
}

#delimit ;
graph combine sat_BEL sat_DNK sat_GRC sat_FRA sat_IRL sat_ITA sat_NLD sat_GBR sat_FRG,
	cols(3)
	ycommon
	imargin(tiny)
	b1title("Real GDP per capita (thousands of dollars, log scale)", size(small))
	l1title("Life satisfaction, ordered probit index relative to country average", size(small))
	name(sat_9, replace)
	xsize(10) ysize(7.5)
;
#delimit cr
graph save "Figures\fig16.gph", replace


restore



use "Processed files/eurobarometer_macro", clear
for X in num 9 10 12 13 16 26 28: gen euX=.
for ! in any BEL DNK FRA FRG GBR IRL ITA LUX NLD: replace eu9=1 if cty=="!"
for ! in any BEL DNK FRA FRG GBR IRL ITA LUX NLD GRC: replace eu10=1 if cty=="!"
for ! in any BEL DNK FRA FRG GBR IRL ITA LUX NLD GRC ESP PRT: replace eu12=1 if cty=="!"
for ! in any BEL DNK FRA FRG GBR IRL ITA LUX NLD GRC ESP PRT GDR: replace eu13=1 if cty=="!"
for ! in any BEL DNK FRA FRG GBR IRL ITA LUX NLD GRC ESP PRT GDR AUT FIN SWE: replace eu16=1 if cty=="!"
for ! in any BEL DNK FRA FRG GBR IRL ITA LUX NLD GRC ESP PRT GDR AUT FIN SWE CYP CZE EST HUN LTU LVA MLT POL SVK SVN: replace eu26=1 if cty=="!"
for ! in any BEL DNK FRA FRG GBR IRL ITA LUX NLD GRC ESP PRT GDR AUT FIN SWE CYP CZE EST HUN LTU LVA MLT POL SVK SVN BGR ROM: replace eu28=1 if cty=="!"

replace wt_euro=. if wt_euro==0
* Form fixed-weight average satisfaction indices, using historical average population shares, calculated separately for each aggregate
for X in num 9 10 12 13 16 26 28: ///
	egen ctX=sum(euX*(sat_hat~=.)*(wt_euro>0)*(wt_euro~=.)), by(date) \ ///
	egen wt_allX=sum(wt_euro*euX*(ctX==X)), by(date) \ ///
	gen wtX=wt_euro/wt_allX if euX==1 & ctX==X \ ///
	egen wt_fixX=mean(wtX), by(cty) \ ///
	egen satX=sum(wt_fixX*sat_hat) if ctX==X & euX==1, by(date) \ ///
	egen gdpX=sum(wt_fixX*gdp_q) if ctX==X & euX==1, by(date) \ ///
	gen lgdpX=ln(gdpX)

* Splice using change in happiness in the broadest available aggregate.
gen dsat=.
gen dy=.
sort cty date
for X in num 9 10 12 13 16 26 28: by cty: replace dsat=satX-satX[_n-1] if satX-satX[_n-1]~=. \ replace dy=gdpX/gdpX[_n-1] if gdpX/gdpX[_n-1]~=.
tomode dsat, by(date) replace
tomode dy, by(date) replace
summ date
gen sat_splice=0 if date==r(min)
gen gdp_splice=100 if date==r(min)
sort cty date
by cty: replace sat_splice=sat_splice[_n-1]+dsat if sat_splice[_n-1]~=.
by cty: replace gdp_splice=gdp_splice[_n-1]*dy if gdp_splice[_n-1]~=.
gen lgdp_splice=ln(gdp_splice)


* Simple average
xi: reg sat_hat i.date [aw=wt_euro]
predict sat_simple if sat_hat~=.
xi: reg gdp_q i.date if sat_hat~=. [aw=wt_euro]
predict gdp_simple
gen lgdp_simple=ln(gdp_simple)

* Regression-adjusted
xi: reg sat_hat i.date i.cty [aw=wt_euro]
for ! in varlist _Icty*: summ ! if sat_hat~=. [aw=wt_euro] \ replace !=r(mean)
predict sat_reg if sat_hat~=.
xi: reg lgdp_q i.date i.cty if sat_hat~=. [aw=wt_euro]
for ! in varlist _Icty*: summ ! if sat_hat~=. &  lgdp_q~=. [aw=wt_euro] \ replace !=r(mean)
predict lgdp_reg if sat_hat~=. & lgdp_q~=.


* Everything begins at zero
summ date if sat_hat~=.
local mind=r(min)
for X in varlist sat_simple sat_splice sat_reg sat9: summ X if date==`mind' \ replace X=X-r(mean)

#delimit ;
twoway
	(line sat_simple date, sort lcolor(gray) mcolor(gs5) lwidth(medthick))
	(line sat9 date, sort lcolor(black) lpattern(solid) lwidth(thin) lpattern(dash))
	(line sat_splice date, sort lcolor(navy) lwidth(thin) lpattern(longdash))
	(line sat_reg date, sort lcolor(green) lwidth(thin) lpattern(solid))
,
	xlabel(1972(4)2008)
	xtitle("")
	ytitle("Life satisfaction (ordered probit index)")
	ylabel(-.2(.1).2, angle(horizontal) format(%4.1f))
	ytick(-.25, notick)
	legend(
		order( 1 "Average of a changing EU" 2 "EU-9 average" 3 "Spliced fixed-weight series"  4 "Regression-adjusted")
		ring(0) pos(6) rows(2) size(small) region(fcolor(none))
		)
	xsize(10) ysize(7.5)
	name(fig17, replace)
;
#delimit cr
graph save "Figures\fig17.gph", replace

* Trend growth
for X in any _simple _splice _reg 9: reg satX date if cty=="FRA" \ reg lgdpX date if cty=="FRA" 




